# Mood Music

A Vue 3 application that provides personalized music recommendations based on your emotions. Built with Vue 3, TypeScript, and Pinia for state management.

## Features

- 🎵 Emotion-based music recommendations
- 🌓 Light/Dark theme support
- 📊 Emotion and play history tracking
- 🔧 Customizable user preferences
- 📱 Responsive design
- 🌍 Multi-language support

## Getting Started

### Prerequisites

- Node.js (v14 or higher)
- npm or yarn

### Installation

1. Clone the repository
```bash
git clone [your-repository-url]
```

2. Install dependencies
```bash
npm install
# or
yarn install
```

3. Start the development server
```bash
npm run dev
# or
yarn dev
```

4. Build for production
```bash
npm run build
# or
yarn build
```

## Project Structure

```
src/
├── assets/          # Static assets
├── components/      # Reusable Vue components
├── router/          # Vue Router configuration
├── services/        # Service layer (storage, audio, etc.)
├── stores/          # Pinia stores
├── types/           # TypeScript type definitions
└── views/           # Page components
```

## Key Components

- `SettingsView`: User preferences management
- `HistoryView`: Emotion and play history tracking
- `MusicPlayer`: Audio playback interface
- `EmotionInput`: Emotion selection interface

## Services

- `storageService`: Local storage management
- `audioPlayer`: Audio playback functionality
- `toastService`: Notification system
- `recommendationService`: Music recommendation engine

## State Management

The application uses Pinia for state management with the following stores:

- `player`: Music playback state
- `emotion`: User emotion tracking
- `settings`: User preferences

## Contributing

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## Acknowledgments

- Vue.js team for the amazing framework
- All contributors who have helped shape this project
