import { defineStore } from 'pinia'

interface EmotionState {
  selectedEmotion: string
  intensity: number
  tags: string[]
  description: string
}

export const useEmotionStore = defineStore('emotion', {
  state: (): EmotionState => ({
    selectedEmotion: '',
    intensity: 5,
    tags: [],
    description: ''
  }),
  
  actions: {
    setEmotion(emotion: string) {
      this.selectedEmotion = emotion
    },
    
    setIntensity(value: number) {
      this.intensity = value
    },
    
    addTag(tag: string) {
      if (!this.tags.includes(tag)) {
        this.tags.push(tag)
      }
    },
    
    setDescription(text: string) {
      this.description = text
    },
    
    resetState() {
      this.selectedEmotion = ''
      this.intensity = 5
      this.tags = []
      this.description = ''
    }
  }
})
