# BBS Backend API Documentation

Base URL: `http://localhost:8000`

## Authentication

### Register
- **URL**: `/api/v1/auth/register`
- **Method**: `POST`
- **Description**: Register a new user
- **Request Body**:
  ```json
  {
    "username": "string",
    "email": "user@example.com",
    "password": "string",
    "avatar": "string",
    "bio": "string"
  }
  ```
- **Curl Example**:
  ```bash
  curl -X POST http://localhost:8000/api/v1/auth/register \
    -H "Content-Type: application/json" \
    -d '{
      "username": "testuser",
      "email": "test3@example.com",
      "password": "password123",
      "avatar": "https://example.com/avatar.jpg",
      "bio": "Hello, I am a test user"
    }'
  ```

### Login
- **URL**: `/api/v1/auth/login`
- **Method**: `POST`
- **Description**: Login to get access token
- **Request Body**:
  ```json
  {
    "email": "user@example.com",
    "password": "string"
  }
  ```
- **Curl Example**:
  ```bash
  curl -X POST http://localhost:8000/api/v1/auth/login \
    -H "Content-Type: application/json" \
    -d '{
      "email": "test3@example.com",
      "password": "password123"
    }'
  ```

### Get Current User
- **URL**: `/api/v1/auth/me`
- **Method**: `GET`
- **Description**: Get current user information
- **Authentication**: Required
- **Curl Example**:
  ```bash
  curl http://localhost:8000/api/v1/auth/me \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ"
  ```

## Posts

### List Posts
- **URL**: `/api/v1/posts`
- **Method**: `GET`
- **Description**: Get list of posts with optional filters
- **Query Parameters**:
  - `category_id` (optional): Filter by category
  - `tag_id` (optional): Filter by tag
  - `author_id` (optional): Filter by author
  - `search` (optional): Search in title and content
  - `page` (optional): Page number
  - `size` (optional): Items per page
- **Curl Example**:
  ```bash
  # List all posts
  curl http://localhost:8000/api/v1/posts

  # With filters
  curl "http://localhost:8000/api/v1/posts?category_id=1&tag_id=2&page=1&size=10"
  ```

### Create Post
- **URL**: `/api/v1/posts`
- **Method**: `POST`
- **Description**: Create a new post
- **Authentication**: Required
- **Request Body**:
  ```json
  {
    "title": "string",
    "content": "string",
    "summary": "string",
    "category_id": 1,
    "tag_ids": [1, 2]
  }
  ```
- **Curl Example**:
  ```bash
  curl -X POST http://localhost:8000/api/v1/posts \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ" \
    -H "Content-Type: application/json" \
    -d '{
      "title": "My First Post",
      "content": "This is the content of my first post",
      "summary": "A brief summary",
      "category_id": 1,
      "tag_ids": [1, 2]
    }'
  ```

### Get Post
- **URL**: `/api/v1/posts/{post_id}`
- **Method**: `GET`
- **Description**: Get a specific post by ID
- **Curl Example**:
  ```bash
  curl http://localhost:8000/api/v1/posts/1
  ```

### Update Post
- **URL**: `/api/v1/posts/{post_id}`
- **Method**: `PUT`
- **Description**: Update an existing post
- **Authentication**: Required
- **Request Body**:
  ```json
  {
    "title": "string",
    "content": "string",
    "summary": "string",
    "category_id": 1,
    "tag_ids": [1, 2]
  }
  ```
- **Curl Example**:
  ```bash
  curl -X PUT http://localhost:8000/api/v1/posts/1 \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ" \
    -H "Content-Type: application/json" \
    -d '{
      "title": "Updated Title",
      "content": "Updated content",
      "summary": "Updated summary",
      "category_id": 1,
      "tag_ids": [1, 2]
    }'
  ```

### Delete Post
- **URL**: `/api/v1/posts/{post_id}`
- **Method**: `DELETE`
- **Description**: Delete a post
- **Authentication**: Required
- **Curl Example**:
  ```bash
  curl -X DELETE http://localhost:8000/api/v1/posts/1 \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ"
  ```

## Comments

### List Comments
- **URL**: `/api/v1/comments`
- **Method**: `GET`
- **Description**: Get list of comments
- **Query Parameters**:
  - `post_id` (optional): Filter by post
  - `parent_id` (optional): Filter by parent comment
  - `page` (optional): Page number
  - `size` (optional): Items per page
- **Curl Example**:
  ```bash
  # List all comments for a post
  curl "http://localhost:8000/api/v1/comments?post_id=1"

  # List replies to a comment
  curl "http://localhost:8000/api/v1/comments?parent_id=1"
  ```

### Create Comment
- **URL**: `/api/v1/comments`
- **Method**: `POST`
- **Description**: Create a new comment
- **Authentication**: Required
- **Request Body**:
  ```json
  {
    "content": "string",
    "post_id": 1,
    "parent_id": null
  }
  ```
- **Curl Example**:
  ```bash
  curl -X POST http://localhost:8000/api/v1/comments \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ" \
    -H "Content-Type: application/json" \
    -d '{
      "content": "This is a comment",
      "post_id": 3,
      "parent_id": null
    }'
  ```

### Get Comment
- **URL**: `/api/v1/comments/{comment_id}`
- **Method**: `GET`
- **Description**: Get a specific comment
- **Curl Example**:
  ```bash
  curl http://localhost:8000/api/v1/comments/1
  ```

### Update Comment
- **URL**: `/api/v1/comments/{comment_id}`
- **Method**: `PUT`
- **Description**: Update a comment
- **Authentication**: Required
- **Request Body**:
  ```json
  {
    "content": "string"
  }
  ```
- **Curl Example**:
  ```bash
  curl -X PUT http://localhost:8000/api/v1/comments/1 \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ" \
    -H "Content-Type: application/json" \
    -d '{
      "content": "Updated comment content"
    }'
  ```

### Delete Comment
- **URL**: `/api/v1/comments/{comment_id}`
- **Method**: `DELETE`
- **Description**: Delete a comment
- **Authentication**: Required
- **Curl Example**:
  ```bash
  curl -X DELETE http://localhost:8000/api/v1/comments/1 \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ"
  ```

## Likes

### Create Like
- **URL**: `/api/v1/likes`
- **Method**: `POST`
- **Description**: Like a post or comment
- **Authentication**: Required
- **Request Body**:
  ```json
  {
    "post_id": 1,
    "comment_id": null
  }
  ```
- **Curl Example**:
  ```bash
  # Like a post
  curl -X POST http://localhost:8000/api/v1/likes \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ" \
    -H "Content-Type: application/json" \
    -d '{
      "post_id": 1
    }'

  # Like a comment
  curl -X POST http://localhost:8000/api/v1/likes \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ" \
    -H "Content-Type: application/json" \
    -d '{
      "comment_id": 1
    }'
  ```

### Delete Post Like
- **URL**: `/api/v1/likes/post/{post_id}`
- **Method**: `DELETE`
- **Description**: Remove like from a post
- **Authentication**: Required
- **Curl Example**:
  ```bash
  curl -X DELETE http://localhost:8000/api/v1/likes/post/1 \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ"
  ```

### Delete Comment Like
- **URL**: `/api/v1/likes/comment/{comment_id}`
- **Method**: `DELETE`
- **Description**: Remove like from a comment
- **Authentication**: Required
- **Curl Example**:
  ```bash
  curl -X DELETE http://localhost:8000/api/v1/likes/comment/1 \
    -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ"
  ```

## Notes for Testing

1. Replace `http://localhost:8000` with your actual server URL if different
2. After registration/login, you'll receive an access token. Replace `eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIzIiwiZXhwIjoxNzMzMzgzNzc1LCJpYXQiOjE3MzMzODE5NzV9.Hw_51CNO3ZvBQ9_6KBUMHemUcQvEfkfRNhux46umcvQ` in the examples with this token
3. For endpoints requiring authentication, always include the Authorization header with your token
4. All request bodies should have Content-Type: application/json header
