from ninja import Router
from typing import List
from .models import Category
from .schemas import CategoryOut

router = Router()

@router.get("/", response=List[CategoryOut])
def list_categories(request):
    """获取所有分类"""
    return Category.objects.all()

@router.get("/{category_id}", response=CategoryOut)
def get_category(request, category_id: int):
    """获取单个分类"""
    return Category.objects.get(id=category_id) 