import { ref } from 'vue'
import { http } from '../utils/http'
import { useToast } from './useToast'

export function useCategories() {
  const categories = ref([])
  const loading = ref(false)
  const error = ref(null)
  const { showToast } = useToast()

  const fetchCategories = async () => {
    loading.value = true
    try {
      console.log('Fetching categories...')
      const response = await http.get('/api/v1/categories')
      console.log('Categories response:', response)
      categories.value = response
    } catch (err) {
      console.error('Error fetching categories:', err)
      error.value = err.message
      showToast('获取分类失败', 'error')
    } finally {
      loading.value = false
    }
  }

  const getCategory = async (id) => {
    try {
      const response = await http.get(`/api/v1/categories/${id}`)
      return response
    } catch (err) {
      showToast('获取分类详情失败', 'error')
      throw err
    }
  }

  return {
    categories,
    loading,
    error,
    fetchCategories,
    getCategory
  }
} 