import { ref } from 'vue'

const visible = ref(false)
const message = ref('')
const type = ref('info')
let timer = null

export function useToast() {
  const showToast = (msg, toastType = 'info', duration = 3000) => {
    if (timer) {
      clearTimeout(timer)
    }
    
    message.value = msg
    type.value = toastType
    visible.value = true
    
    timer = setTimeout(() => {
      visible.value = false
    }, duration)
  }

  return {
    visible,
    message,
    type,
    showToast
  }
}
