import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [vue()],
  build: {
    chunkSizeWarningLimit: 600,
    rollupOptions: {
      output: {
        manualChunks: (id) => {
          if (id.includes('node_modules')) {
            if (id.includes('vue') || id.includes('pinia')) {
              return 'vendor'
            }
            return 'deps'
          }
        }
      }
    }
  },
  server: {
    proxy: {
      '/api': {
        target: 'https://domaintestaccount.store',
        changeOrigin: true
      }
    }
  }
})