import { createRouter, createWebHistory } from 'vue-router'
import HomeView from '../views/HomeView.vue'
import EmotionInput from '../views/EmotionInput.vue'
import MusicPlayer from '../views/MusicPlayer.vue'
import SettingsView from '../views/SettingsView.vue'
import HistoryView from '../views/HistoryView.vue'
import LastFmCallback from '../views/LastFmCallback.vue'

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/',
      name: 'home',
      component: HomeView,
    },
    {
      path: '/emotion-input',
      name: 'emotion-input',
      component: EmotionInput,
    },
    {
      path: '/music-player',
      name: 'music-player',
      component: () => import('../views/MusicPlayer.vue'),
    },
    {
      path: '/settings',
      name: 'settings',
      component: SettingsView,
    },
    {
      path: '/history',
      name: 'history',
      component: HistoryView,
    },
    {
      path: '/callback',
      name: 'callback',
      component: LastFmCallback,
    },
  ],
})

export default router
